/*
 * Decompiled with CFR 0.152.
 */
package Communications;

import Communications.Buffer;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutputBuffer
extends Buffer
implements Closeable {
    private DataOutputStream buffer;

    public OutputBuffer(String filepath) throws IOException {
        File VB6File = new File(filepath);
        VB6File.delete();
        VB6File.createNewFile();
        FileOutputStream fileStream = new FileOutputStream(VB6File, true);
        this.buffer = new DataOutputStream(fileStream);
    }

    public OutputBuffer(OutputStream outputStream) throws IOException {
        this.buffer = new DataOutputStream(outputStream);
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public void writeInt(int value) throws IOException {
        this.buffer.writeInt(Integer.reverseBytes(value));
    }

    public void writeShort(short value) throws IOException {
        this.buffer.writeShort(Short.reverseBytes(value));
    }

    public void writeString(String text) throws IOException {
        int stringSize = text.length();
        this.writeShort((short)stringSize);
        this.writeString(text, stringSize);
    }

    public void writeString(String text, int stringSize) throws IOException {
        text = String.format("%1$-" + stringSize + "." + stringSize + "s", text);
        this.buffer.writeBytes(text);
    }

    public void writeByte(byte value) throws IOException {
        this.buffer.writeByte(value);
    }

    public void writeBoolean(boolean value) throws IOException {
        this.buffer.writeBoolean(value);
        this.buffer.writeBoolean(value);
    }

    public void writeLong(long value) throws IOException {
        this.buffer.writeLong(Long.reverseBytes(value));
    }

    public void writeFloat(float value) throws IOException {
        this.buffer.writeInt(Integer.reverseBytes(Float.floatToIntBits(value)));
    }

    public void writeDouble(double value) throws IOException {
        this.buffer.writeLong(Long.reverseBytes(Double.doubleToLongBits(value)));
    }
}

