/*
 * Decompiled with CFR 0.152.
 */
package Miscs;

import Miscs.LibraryException;
import Miscs.ParsingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageLogger {
    private static MessageLogger INSTANCE = null;
    private Logger logger = Logger.getLogger("logger");

    private MessageLogger() {
        this.logger.setLevel(Level.WARNING);
    }

    private static final synchronized MessageLogger getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MessageLogger();
        }
        return INSTANCE;
    }

    public static void inform(String text) {
        MessageLogger.getInstance().logger.log(Level.INFO, text);
    }

    public static void warn(String text) {
        MessageLogger.getInstance().logger.log(Level.WARNING, text);
    }

    public static void stop(String text) throws ParsingException {
        MessageLogger.getInstance().logger.log(Level.SEVERE, text);
        throw new ParsingException(text);
    }

    public static void stop(Exception e) throws LibraryException {
        MessageLogger.getInstance().logger.log(Level.SEVERE, e.toString());
        throw new LibraryException(e);
    }

    public static void set(Level displayLevel) {
        MessageLogger.getInstance().logger.setLevel(displayLevel);
    }
}

