package Test;

import java.io.IOException;

import Communications.InputBuffer;
import Miscs.ParsingException;

public class File {
	public Header h = new Header();
	public Body b = new Body();
	
	public File(String filepath) throws ParsingException, IOException
	{
		// An InputBuffer can be reused during multiple deserialization
		InputBuffer buff = new InputBuffer(filepath);
		
		try {
			// Deserialize the header
			h.deserialize(buff);
			
			// Init the body array with the correct amount of data (according to the header values)
			b.array = new double[h.total];
			
			// Deserialize the file's body
			b.deserialize(buff);
		}
		finally {
			buff.close();
		}
	}
}
