package Test;

import java.io.IOException;
import java.util.logging.Level;

import Miscs.MessageLogger;
import Miscs.ParsingException;


public class Main {

	/**
	 * @param args
	 * @throws ParsingException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws ParsingException, IOException {
		/*
		 * This example allow to deserialize a VB6 binary file in multiple phases.
		 * VB6 corresponding structure :
		 *    Public Type FileRec
		 *     total As Integer  (Must contain 3 : body content size)
		 *     text(0 To 1, 0 To 2) As String * 10  (Must contain a serie from "one" to "six")
		 *     
		 *     firstNumber As Double  (Must contain 1.23)
		 *     secondNumber As Double  (Must contain 4.56)
		 *     thirdNumber As Double  (Must contain 7.89)
		 *    End Type
		 */
		
		MessageLogger.set(Level.INFO);
		File test = new File("Files/test.fil");
		
		for (int i = 0 ; i < test.h.text.length ; i++)
		{
			for (int j = 0 ; j < test.h.text[0].length ; j++)
			{
				System.out.println("A string in the header text : "+test.h.text[i][j]);
			}
		}
		
		System.out.println("Body length : " + test.h.total);
		System.out.println("Body value 1 : "+test.b.array[0]);
		System.out.println("Body value 2 : "+test.b.array[1]);
		System.out.println("Body value 3 : "+test.b.array[2]);
	}

}
