package Test;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;

import Communications.InputBuffer;
import Miscs.MessageLogger;
import Miscs.ParsingException;


public class Main {

	/**
	 * @param args
	 * @throws ParsingException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws ParsingException, IOException {
		
		MessageLogger.set(Level.INFO);
		Npc test = new Npc();
		
		test.id = 3; // Will not be serialized
		
		// Will be serialized
		test.name = "this_is_a_name";
		test.strength = 2;
		test.vitality = 1;
		test.characterTraits = new Trait[2];
		
		for (int i = 0 ; i < test.characterTraits.length ; i++)
		{
			test.characterTraits[i] = new Trait();
			test.characterTraits[i].label = "Trait"+i;
		}
		
		// adding multiple fields to test many cases
		test.a = 1.05;
		test.b = (float) 2.5554;
		test.c = "toto";

		test.d = new boolean[2][2];
		test.d[0][0] = true;
		test.d[0][1] = false;
		test.d[1][0] = true;
		test.d[1][1] = false;
		
		test.e = 4;
		
		test.end = "end";

		// NB : Serialization could be processed in many times through an output buffer
		test.serialize("Npcs/test.npc");
		
		// Try to deserialize the newly created NPC
		Npc test2 = new Npc();
		test2.d = new boolean[2][2];
		
		// Try using our own InputStream to deserialize
		FileInputStream fileStream = new FileInputStream(new java.io.File("Npcs/test.npc"));
		InputBuffer buff = new InputBuffer(fileStream);
		try {
			test2.deserialize(buff);
			System.out.println(test2.end); // Must print "end"
		}
		finally {
			buff.close();
		}
	}

}
