/*
 * Decompiled with CFR 0.152.
 */
package Communications;

import Annotations.DeserializeIgnore;
import Annotations.StaticArray;
import Annotations.StringSize;
import Communications.InputBuffer;
import Communications.OutputBuffer;
import Miscs.ArrayUtils;
import Miscs.MessageLogger;
import Miscs.ParsingException;
import java.io.EOFException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;

public class VB6Binary {
    public void serialize(String filepath) throws ParsingException, IOException {
        try (OutputBuffer fileBuffer = new OutputBuffer(filepath);){
            this.serialize(fileBuffer);
        }
    }

    public void serialize(OutputBuffer buffer) throws ParsingException, IOException {
        Field[] fields;
        Field[] fieldArray = fields = this.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            boolean mustProcessField = true;
            if (f.getName().toString().compareTo("this$0") == 0) {
                mustProcessField = false;
            }
            if (f.getAnnotation(DeserializeIgnore.class) != null) {
                mustProcessField = false;
            }
            if (mustProcessField) {
                MessageLogger.inform("Writing field '" + f.getName() + "'");
                if (f.getType().isArray()) {
                    this.writeProfundis(buffer, f);
                } else {
                    this.writeNext(buffer, this.getFieldValueMandatory(f), f.getAnnotations());
                }
            }
            ++n2;
        }
    }

    private Object getFieldValue(Field f) throws ParsingException {
        Object rval = null;
        try {
            rval = f.get(this);
        }
        catch (IllegalAccessException | IllegalArgumentException e1) {
            MessageLogger.stop(e1);
        }
        return rval;
    }

    private Object getFieldValueMandatory(Field f) throws ParsingException {
        Object rval = this.getFieldValue(f);
        if (rval == null) {
            MessageLogger.stop("Field " + f.getName() + " is not set.");
        }
        return rval;
    }

    private void writeProfundis(OutputBuffer buffer, Field f) throws ParsingException, IOException {
        Object array = this.getFieldValueMandatory(f);
        int dimension = ArrayUtils.getArrayDimension(array);
        int[] lengths = ArrayUtils.getArrayLength(array);
        MessageLogger.inform("Dim : " + dimension + ". Lengths : " + Arrays.toString(lengths));
        if (f.getAnnotation(StaticArray.class) == null) {
            buffer.writeShort((short)dimension);
            int i = dimension - 1;
            while (i >= 0) {
                buffer.writeLong(lengths[i]);
                --i;
            }
        }
        int[] counter = new int[dimension];
        int nbIteration = 1;
        int i = 0;
        while (i < dimension) {
            nbIteration *= lengths[i];
            ++i;
        }
        i = 0;
        while (i < nbIteration) {
            Object currentArray = array;
            int j = 0;
            while (j < dimension - 1) {
                currentArray = Array.get(currentArray, counter[j]);
                ++j;
            }
            Object value = Array.get(currentArray, counter[dimension - 1]);
            this.writeNext(buffer, value, f.getAnnotations());
            this.incrementCounter(counter, lengths);
            ++i;
        }
    }

    private void writeNext(OutputBuffer buffer, Object value, Annotation[] annotations) throws ParsingException, IOException {
        Class<?> type = value.getClass();
        if (type.equals(String.class)) {
            int i = 0;
            while (i < annotations.length) {
                Annotation currentAnnotation = annotations[i];
                if (currentAnnotation.annotationType().equals(StringSize.class)) {
                    buffer.writeString((String)value, ((StringSize)currentAnnotation).size());
                    i = annotations.length + 1;
                    continue;
                }
                ++i;
            }
            if (i == annotations.length) {
                buffer.writeString((String)value);
            }
        } else if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            buffer.writeInt((Integer)value);
        } else if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            buffer.writeShort((Short)value);
        } else if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            buffer.writeByte((Byte)value);
        } else if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            buffer.writeBoolean((Boolean)value);
        } else if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            buffer.writeFloat(((Float)value).floatValue());
        } else if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            buffer.writeDouble((Double)value);
        } else {
            ((VB6Binary)value).serialize(buffer);
        }
        MessageLogger.inform("Writing type : " + type + " with value : " + value);
    }

    public void deserialize(String filepath) throws ParsingException, IOException {
        try (InputBuffer fileBuffer = new InputBuffer(filepath);){
            this.deserialize(fileBuffer);
        }
    }

    public void deserialize(InputBuffer buffer) throws ParsingException, IOException {
        Field[] fields;
        Field[] fieldArray = fields = this.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            boolean mustProcessField = true;
            if (f.getName().toString().compareTo("this$0") == 0) {
                mustProcessField = false;
            }
            if (f.getAnnotation(DeserializeIgnore.class) != null) {
                mustProcessField = false;
            }
            if (mustProcessField) {
                MessageLogger.inform("Reading field '" + f.getName() + "'");
                if (f.getType().isArray()) {
                    Object tab = this.readProfundis(buffer, f);
                    try {
                        f.set(this, tab);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        MessageLogger.stop(e);
                    }
                } else {
                    try {
                        f.set(this, this.readNext(buffer, f.getType(), f.getAnnotations()));
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        MessageLogger.stop(e);
                    }
                    catch (EOFException e) {
                        MessageLogger.stop("EOF encounter while reading field '" + f.getName() + "'");
                    }
                }
            }
            ++n2;
        }
    }

    private void incrementCounter(int[] counter, int[] lengths) {
        this.incrementCounter(counter, lengths, 0);
    }

    private void incrementCounter(int[] counter, int[] lengths, int index) {
        int n = index;
        counter[n] = counter[n] + 1;
        if (counter[index] == lengths[index]) {
            counter[index] = 0;
            if (++index < counter.length) {
                this.incrementCounter(counter, lengths, index);
            }
        }
    }

    private Object readProfundis(InputBuffer buffer, Field f) throws ParsingException, IOException {
        int[] lengths;
        int dimension;
        Object newArray = null;
        if (f.getAnnotation(StaticArray.class) != null) {
            newArray = this.getFieldValueMandatory(f);
            dimension = ArrayUtils.getArrayDimension(newArray);
            lengths = ArrayUtils.getArrayLength(newArray);
            MessageLogger.inform("Dim : " + dimension + ". Lengths : " + Arrays.toString(lengths));
        } else {
            dimension = buffer.readShort();
            lengths = new int[dimension];
            int i = dimension - 1;
            while (i >= 0) {
                lengths[i] = (int)buffer.readLong();
                --i;
            }
            MessageLogger.inform("Dim : " + dimension + ". Lengths : " + Arrays.toString(lengths));
            newArray = Array.newInstance(ArrayUtils.getArrayType(f), lengths);
        }
        int[] counter = new int[dimension];
        int nbIteration = 1;
        int i = 0;
        while (i < dimension) {
            nbIteration *= lengths[i];
            ++i;
        }
        i = 0;
        while (i < nbIteration) {
            Object currentArray = newArray;
            int j = 0;
            while (j < dimension - 1) {
                currentArray = Array.get(currentArray, counter[j]);
                ++j;
            }
            try {
                Object value = this.readNext(buffer, ArrayUtils.getArrayType(f), f.getAnnotations());
                Array.set(currentArray, counter[dimension - 1], value);
            }
            catch (EOFException e) {
                MessageLogger.stop("EOF encounter while reading field '" + f.getName() + "'");
            }
            this.incrementCounter(counter, lengths);
            ++i;
        }
        return newArray;
    }

    private Object readNext(InputBuffer buffer, Class<?> type, Annotation[] annotations) throws ParsingException, IOException {
        Object rval = null;
        if (type.equals(String.class)) {
            int i = 0;
            while (rval == null && i < annotations.length) {
                Annotation currentAnnotation = annotations[i];
                if (currentAnnotation.annotationType().equals(StringSize.class)) {
                    rval = buffer.readString(((StringSize)currentAnnotation).size());
                }
                ++i;
            }
            if (rval == null) {
                rval = buffer.readString();
            }
        } else if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
            rval = buffer.readInt();
        } else if (Short.TYPE.equals(type) || Short.class.equals(type)) {
            rval = buffer.readShort();
        } else if (Byte.TYPE.equals(type) || Byte.class.equals(type)) {
            rval = buffer.readByte();
        } else if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
            rval = buffer.readBoolean();
        } else if (Float.TYPE.equals(type) || Float.class.equals(type)) {
            rval = Float.valueOf(buffer.readFloat());
        } else if (Double.TYPE.equals(type) || Double.class.equals(type)) {
            rval = buffer.readDouble();
        } else {
            try {
                rval = type.newInstance();
                ((VB6Binary)rval).deserialize(buffer);
            }
            catch (IllegalAccessException | InstantiationException e2) {
                MessageLogger.stop(e2);
            }
        }
        MessageLogger.inform("Reading type : " + type + " with value : " + rval);
        return rval;
    }
}

