/*
 * Decompiled with CFR 0.152.
 */
package Communications;

import Communications.Buffer;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputBuffer
extends Buffer
implements Closeable {
    private DataInputStream buffer;

    public InputBuffer(String filepath) throws IOException {
        FileInputStream fileStream = new FileInputStream(new File(filepath));
        this.buffer = new DataInputStream(fileStream);
    }

    public InputBuffer(InputStream inputStream) {
        this.buffer = new DataInputStream(inputStream);
    }

    @Override
    public void close() throws IOException {
        this.buffer.close();
    }

    public int readInt() throws IOException {
        int rval = Integer.reverseBytes(this.buffer.readInt());
        return rval;
    }

    public short readShort() throws IOException {
        short rval = Short.reverseBytes(this.buffer.readShort());
        return rval;
    }

    public String readString() throws IOException {
        short stringSize = this.readShort();
        return this.readString(stringSize);
    }

    public String readString(int stringSize) throws IOException {
        String rval = "";
        byte[] byteString = new byte[stringSize];
        int nbRead = this.buffer.read(byteString);
        if (nbRead < stringSize) {
            throw new EOFException();
        }
        rval = new String(byteString);
        return rval;
    }

    public byte readByte() throws IOException {
        byte rval = this.buffer.readByte();
        return rval;
    }

    public boolean readBoolean() throws IOException {
        boolean rval = this.buffer.readBoolean();
        this.buffer.skipBytes(1);
        return rval;
    }

    public long readLong() throws IOException {
        long rval = Long.reverseBytes(this.buffer.readLong());
        return rval;
    }

    public float readFloat() throws IOException {
        float rval = Float.intBitsToFloat(this.readInt());
        return rval;
    }

    public double readDouble() throws IOException {
        double rval = Double.longBitsToDouble(this.readLong());
        return rval;
    }

    public void skipBytes(int n) throws IOException {
        this.buffer.skipBytes(n);
    }
}

