package Test;

import java.io.IOException;
import java.util.logging.Level;

import Miscs.MessageLogger;
import Miscs.ParsingException;


public class Main {

	/**
	 * @param args
	 * @throws ParsingException 
	 * @throws IOException 
	 */
	public static void main(String[] args) throws ParsingException, IOException {
		
		MessageLogger.set(Level.INFO);
		Npc test = new Npc();
		
		test.id = 3; // Will not be serialized
		
		// Will be serialized
		test.name = "this_is_a_name";
		test.strength = 2;
		test.vitality = 1;
		test.characterTraits = new Trait[2];
		
		for (int i = 0 ; i < test.characterTraits.length ; i++)
		{
			test.characterTraits[i] = new Trait();
			test.characterTraits[i].label = "Trait"+i;
		}

		// NB : Serialization could be processed in many times through an output buffer
		test.serialize("Npcs/test.npc");
	}

}
